/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_Fiq.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    USER - Headerfile of Fast Interrupt Driver Module

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-23  File created.

**************************************************************************************/


#ifndef __AP_FIQ_H
#define __AP_FIQ_H

#ifdef __cplusplus
extern "C" {
#endif

 /*
  **************************************************************************
  *   Size of one Interrupt Control Block a Task has to allocate memory for
  **************************************************************************
  */ 
  #define DRV_FIQ_SIZE (52)

  /*
  ************************************************************
  *   Function Prototypes
  ************************************************************
  */

  typedef void(CALLBACK FAR* APP_FIQ_HANDLER)(void); 
  
  RX_FATAL FAR    DrvFiqInit                  (const FAR void FAR*      pvCfg,
                                               UINT                     uNum); 

  RX_RESULT FAR   Drv_FiqCreateInterrupt      (RX_HANDLE                hFiq,
                                               const RX_FIQ_SET_T FAR*  ptCfg); 
  
  RX_RESULT FAR   Drv_FiqIdentifyInterrupt    (STRING FAR*              pszIdn,
                                               UINT                     uInst,
                                               RX_HANDLE FAR*           phInt); 

  RX_RESULT FAR   Drv_FiqInitializeInterrupt  (RX_HANDLE                hFiq,
                                               APP_FIQ_HANDLER          fnAppISR); 
                                           
  RX_RESULT FAR   Drv_FiqEnableInterrupt      (RX_HANDLE                hFiq);
  RX_RESULT FAR   Drv_FiqDisableInterrupt     (RX_HANDLE                hFiq);

#ifdef __cplusplus
}
#endif

#endif
